import tkinter
import random
import os
import Team, Sezona
from time import strftime
from datetime import datetime

class Program():
    class Posuvnik():
        def __init__(self, canvas, x, y, sirka, pocet_moznosti):
            self.canvas = canvas
            self.x, self.y = x, y
            self.posuvnik_x = x
            self.sirka = sirka
            self.pocet_moznosti = pocet_moznosti

        def vykresli(self):
            self.canvas.create_rectangle(self.x, self.y, self.x + self.sirka, self.y + 4, fill="white")
            self.id = self.canvas.create_rectangle(self.posuvnik_x, self.y - 13, self.posuvnik_x + 40, self.y + 17, fill="red")

        def range_x(self):
            x_dolna, _, x_horna, _ = self.canvas.coords(self.id)
            return range(int(x_dolna), int(x_horna + 1))

        def range_y(self):
            _, y_dolna, _, y_horna = self.canvas.coords(self.id)
            return range(int(y_dolna), int(y_horna + 1))

        def nastav(self, nove_x):
            self.canvas.delete(self.id)
            self.posuvnik_x = nove_x - 20
            
            if(self.posuvnik_x < self.x):
                self.posuvnik_x = self.x
            if(self.posuvnik_x > self.x + self.sirka - 40):
                self.posuvnik_x = self.x + self.sirka - 40
                
            self.vykresli()

        def get(self):
            try:
                sirka_dielika = (self.sirka - 40) / self.pocet_moznosti
            except:
                sirka_dielika = (self.sirka - 40) / 1
            sirka = self.posuvnik_x - self.x

            return int(sirka / sirka_dielika + 1)

    
    def __init__(self):
        #info o hracovi
        self.sezona = None

        #setup canvasu
        self.canvas = tkinter.Canvas(width=1280, height=720)
        self.canvas.master.title("Formula Simulator 2018")
        self.entry = []
        self.canvas.pack()
        self.nabinduj()

        self.obrazovka = "uvod"
        self.tlacidlo_pretek = "Hlavny pretek"
        self.procesy = dict()

        #info o novom teame
        self.novy_team_info = dict()
        #self.jazdec_1, self.jazdec_2
        self.info_jazdec_1 = dict()
        self.info_jazdec_2 = dict()
        self.info_pitstop = dict()
        self.subor_cesta = ""
        self.subor_cislo = -1

        #signaly
        self.trening_tlacidlo = False
        self.pitstop = False

        #
        self.uvod()
        self.canvas.mainloop()

    def reset(self):
        self.sezona = None
        self.novy_team_info = dict()
        self.info_jazdec_1 = dict()
        self.info_jazdec_2 = dict()
        self.subor_cesta = ""
        self.subor_cislo = -1

    def klik(self, event):
        #uvodna obrazovka hry
        if(self.obrazovka == "uvod"):
            #tlacidlo "New Game"
            if(event.x in range(975,1226) and event.y in range(170,221)):
                self.nova_hra()
            #tlacidlo "Load Game"
            if(event.x in range(975,1226) and event.y in range(230,281)):
                self.ulozene_pozicie("nacitaj_poziciu")
            #Tlacidlo "Credits"
            #if(event.x in range(975,1226) and event.y in range(290,341)):
                #self.sezona.vykresli_simulacia_okno("Marek Jaros", 10)
            
                
        if(self.obrazovka == "nova hra"):
            #tlacidlo "Spat"
            if(event.x in range(68, 179) and event.y in range(635, 681)):
                #zmaze entry polia
                self.novy_team_info["meno_manazera"].destroy()
                self.novy_team_info["meno_teamu"].destroy()
                self.uvod()
            #tlacidlo Start
            if(event.x in range(292, 403) and event.y in range(635, 681)):
                self.start_novej_hry()
                #zmaze entry polia
                self.novy_team_info["meno_manazera"].destroy()
                self.novy_team_info["meno_teamu"].destroy()
            #tlacidlo Random
            if(event.x in range(210, 261) and event.y in range(635, 658)):
                self.novy_team_info["manazer"].nahodny_vyber()
                self.novy_team_info["manazer"].vykresli(235, 470)
            #nastavenie vlasov
            if(event.x in range(402, 439) and event.y in range(370, 391)):
                self.novy_team_info["manazer"].nastav_obrazok("vlasy", 1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            if(event.x in range(32, 69) and event.y in range(370, 391)):
                self.novy_team_info["manazer"].nastav_obrazok("vlasy", -1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            #nastavenie oci
            if(event.x in range(402, 439) and event.y in range(402, 439)):
                self.novy_team_info["manazer"].nastav_obrazok("oci", 1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            if(event.x in range(32, 69) and event.y in range(402, 439)):
                self.novy_team_info["manazer"].nastav_obrazok("oci", -1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            #nastavenie ust
            if(event.x in range(402, 439) and event.y in range(472, 509)):
                self.novy_team_info["manazer"].nastav_obrazok("usta", 1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            if(event.x in range(32, 69) and event.y in range(472, 509)):
                self.novy_team_info["manazer"].nastav_obrazok("usta", -1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            #nastavenie oblecenia
            if(event.x in range(402, 439) and event.y in range(552, 589)):
                self.novy_team_info["manazer"].nastav_obrazok("oblecenie", 1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            if(event.x in range(32, 69) and event.y in range(552, 589)):
                self.novy_team_info["manazer"].nastav_obrazok("oblecenie", -1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            #nastavenie tela
            if(event.x in range(402, 439) and event.y in range(592, 629)):
                self.novy_team_info["manazer"].nastav_obrazok("telo", 1)
                self.novy_team_info["manazer"].vykresli(235, 470)
            if(event.x in range(32, 69) and event.y in range(592, 629)):
                self.novy_team_info["manazer"].nastav_obrazok("telo", -1)
                self.novy_team_info["manazer"].vykresli(235, 470)

        if(self.obrazovka == "nacitat"):
            #Tlacidlo 'Ok', ak niekto chce nacitavat neplatny subor
            if(event.x in range(585,696) and event.y in range(400,446)):
                self.subor_cislo = -1
                self.ulozene_pozicie("nacitaj_poziciu")

        if(self.obrazovka == "nova_hra_save"):
            #vyberie subor
            for i in range(5):
                if(event.x in range(50, 421) and event.y in range(200 + (i*80), 200 + (i*80) + 51)):
                    self.subor_cislo = i
                    self.ulozene_pozicie("nova_hra_save")
            #Tlacidlo 'Spat'
            if(event.x in range(800, 911) and event.y in range(635, 681)):
                self.subor_cislo = -1
                self.nova_hra()
            #Tlacidlo 'Prepisat'
            if(event.x in range(1000, 1111) and event.y in range(635, 681)):
                self.prepisat()
                    
        if(self.obrazovka == "nacitaj_poziciu"):
            #vyberie subor
            for i in range(5):
                if(event.x in range(50, 421) and event.y in range(200 + (i*80), 200 + (i*80) + 51)):
                    self.subor_cislo = i
                    self.ulozene_pozicie("nacitaj_poziciu")
            #Tlacidlo 'Spat'
            if(event.x in range(800, 910) and event.y in range(635, 681)):
                self.subor_cislo = -1
                self.uvod()
            #Tlacidlo 'Nacitat'
            if(event.x in range(1000, 1111) and event.y in range(635, 681)):
                self.nacitat()

        if(self.obrazovka == "prepisat"):
            #Tlacidlo 'Ok'
            if(self.subor_cislo not in range(0,6) and event.x in range(585,696) and event.y in range(400,446)):
                self.ulozene_pozicie("nova_hra_save")
            #Tlacidlo 'Spat'
            if(self.subor_cislo in range(0,6) and event.x in range(485,596) and event.y in range(400,446)):
                self.novy_team_info["meno_suboru"].destroy()
                self.ulozene_pozicie("nova_hra_save")
            #Tlacidlo 'Potvrdit'
            if(self.subor_cislo in range(0,6) and event.x in range(685,796) and event.y in range(400,446)):
                self.prepisat_potvrdenie()
                self.novy_team_info["meno_suboru"].destroy()
                self.hra()

        if(self.obrazovka == "hra"):
            #Tlacidlo 'Sampionaty'
            if(event.x in range(320, 531) and event.y in range(200, 246)):
                self.sampionaty()
            #Tlacidlo 'Statistiky'
            if(event.x in range(320, 531) and event.y in range(145, 191)):
                self.statistiky()
            #Tlacidlo 'Odist'
            if(event.x in range(1110, 1221) and event.y in range(200, 246)):
                self.subor_cislo = -1
                self.sezona.ulozit(self.subor_cesta)
                self.uvod()
            #Tlacidlo 'Novy Pretek'
            if(event.x in range(60, 271) and event.y in range(145, 246)):
                self.pretek()

        if(self.obrazovka == "trening"):
            #Tlacidlo 'Odist'
            if(self.trening_tlacidlo and event.x in range(1110, 1221) and event.y in range(668, 714)):
                self.sezona.dalsia_faza()
                self.sezona.ulozit(self.subor_cesta)
                self.hra()
            #Tlacidlo 'Pitstop' jazdec_1
            if(event.x in range(550, 661) and event.y in range(300, 346)):
                self.pitstop = True
                self.jazdec_1.pitstop = True
            #Tlacidlo 'Pitstop' jazdec_2
            if(event.x in range(550, 661) and event.y in range(660, 706)):
                self.pitstop = True
                self.jazdec_2.pitstop = True

        if(self.obrazovka == "pitstop"):
            #Pneumatiky 'S'
            if(event.x in range(460, 561) and event.y in range(550,651)):
                self.info_pitstop["pneumatiky"] = 0
                self.pitstop_okno(self.info_pitstop["jazdec"])
            #Pneumatiky 'M'
            if(event.x in range(590, 691) and event.y in range(550,651)):
                self.info_pitstop["pneumatiky"] = 1
                self.pitstop_okno(self.info_pitstop["jazdec"])
            #Pneumatiky 'H'
            if(event.x in range(720, 821) and event.y in range(550,651)):
                self.info_pitstop["pneumatiky"] = 2
                self.pitstop_okno(self.info_pitstop["jazdec"])
            1110, 668, 1220, 713
            #Tlacidlo 'Pitstop'
            if(event.x in range(1110, 1221) and event.y in range(668,714)):
                info = []
                try:
                    if(self.info_pitstop["pneumatiky"] == 0):
                        info.append("S")
                    elif(self.info_pitstop["pneumatiky"] == 1):
                        info.append("M")
                    else:
                        info.append("H")
                except:
                    pass
                info.append(self.info_pitstop["palivo"].get() - 1)
                self.info_pitstop["jazdec"].pitstop_info = info
                print("MENO ---> ", self.info_pitstop["jazdec"].meno)
                #
                self.pitstop = False
                self.info_pitstop = dict()
                #self.sezona.kolo += 1
                if(self.sezona.faza_preteku in range(1,4)):
                    trening = True
                else:
                    trening = False
                self.procesy["trening"] = self.canvas.after(1000, self.trening,
                                                        self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], trening)

        if(self.obrazovka == "kvalifikacia"):
            #Tlacidlo 'Odist'
            if(self.trening_tlacidlo and event.x in range(1110, 1221) and event.y in range(668, 714)):
                self.sezona.dalsia_faza()
                self.sezona.ulozit(self.subor_cesta)
                self.hra()

        if(self.obrazovka == "sampionaty"):
            #Tlacidlo 'Odist'
            if(event.x in range(1110, 1221) and event.y in range(668, 714)):
                self.hra()

        if(self.obrazovka == "statistiky"):
            #Tlacidlo 'Odist'
            if(event.x in range(1110, 1221) and event.y in range(668, 714)):
                self.hra()
                    

    def spracuj_text(self, nazov_suboru, sirka):
        text_subor = open(nazov_suboru, "r")
        text = ""
        
        for riadok in text_subor:
            text += riadok.strip() + " "
            
        text = text.split(" ")
        result = ""
        dlzka_riadka = 0
        for slovo in text:
            if(slovo == "<n>"):
                result += "\n"
                dlzka_riadka = 0
                continue
            if(dlzka_riadka > sirka - 1):
                result += "\n"
                dlzka_riadka = 0
            result += slovo + " "
            dlzka_riadka += len(slovo) + 1
            
        return result
    
    def uvod(self):
        #nastavenie
        self.obrazovka = "uvod"
        self.reset()
        #POZADIE
        self.background = tkinter.PhotoImage(file="obrazky\\uvod-{}.png".format(random.randint(1,5)))
        self.canvas.create_image(640, 360, image=self.background)
        #MENU
        #self.canvas.create_rectangle(950, 160, 1250, 560, fill="gray", stipple="gray25", outline="gray", dash=(1,1))
        #--tlacidla
        self.canvas.create_rectangle(975, 170, 1225, 220, fill="red", stipple="gray75")
        self.canvas.create_text(1100, 195, text="Nová hra", font="Ariel 22")

        self.canvas.create_rectangle(975, 230, 1225, 280, fill="red", stipple="gray75")
        self.canvas.create_text(1100, 255, text="Načitaj hru", font="Ariel 22")

        #self.canvas.create_rectangle(975, 290, 1225, 340, fill="red", stipple="gray75")
        #self.canvas.create_text(1100, 315, text="Credits", font="Ariel 22")

        self.canvas.create_text(1100, 705, fill="white", font="Ariel 15", text="© Marek Jaros | 2018")

    def nova_hra(self):
        #nastavenie
        self.obrazovka = "nova hra"
        self.canvas.delete("all")
        self.canvas.configure(bg="#e2e2e2")
        self.doprava = tkinter.PhotoImage(file="obrazky\\doprava.png")
        self.dolava = tkinter.PhotoImage(file="obrazky\\dolava.png")
        self.novy_team_info = dict()
        #meno manazera
        self.canvas.create_text(130, 50, text="Team manazer", font="Ariel 15")
        self.novy_team_info["meno_manazera"] = tkinter.Entry(master=self.canvas, font="Ariel 15")
        self.novy_team_info["meno_manazera"].pack()
        self.novy_team_info["meno_manazera"].place(x=205, y=38, width=200, height=30)
        #nazov teamu
        self.canvas.create_text(130, 95, text="Nazov teamu  ", font="Ariel 15")
        self.novy_team_info["meno_teamu"] = tkinter.Entry(master=self.canvas, font="Ariel 15")
        self.novy_team_info["meno_teamu"].pack()
        self.novy_team_info["meno_teamu"].place(x=205, y=83, width=200, height=30)
        #ciara
        self.canvas.create_line(470, 35, 470, 685, fill="black")
        #obtiaznost
        self.canvas.create_text(145, 135, text="Zvolte obtiaznost:", font="Ariel 15")
        self.canvas.create_text(92, 160, text="Najlahsia")
        self.canvas.create_text(380, 160, text="Najtazsia")
        self.novy_team_info["posuvnik_obtiaznost"] = self.Posuvnik(self.canvas, 68, 185, 335, 3)
        self.novy_team_info["posuvnik_obtiaznost"].vykresli()
        #dlzka sezony
        self.canvas.create_text(155, 225, text="Zvolte dlzku sezony:", font="Ariel 15")
        self.canvas.create_text(93, 250, text="Najkratsia")
        self.canvas.create_text(380, 250, text="Najdlhsia")
        self.novy_team_info["posuvnik_sezona"] = self.Posuvnik(self.canvas, 68, 275, 335, 7)
        self.novy_team_info["posuvnik_sezona"].vykresli()
        #---obrazok manazera
        self.novy_team_info["manazer"] = Team.Jazdec(self.canvas)
        self.novy_team_info["manazer"].vykresli(235, 470, 1)
            #vlasy
        self.canvas.create_text(50, 360, text="Vlasy", font="Ariel 10")
        self.canvas.create_image(420, 380, image=self.doprava)
        self.canvas.create_image(50, 380, image=self.dolava)
            #oci
        self.canvas.create_text(50, 400, text="Oci", font="Ariel 10")
        self.canvas.create_image(420, 420, image=self.doprava)
        self.canvas.create_image(50, 420, image=self.dolava)
            #usta
        self.canvas.create_text(50, 470, text="Usta", font="Ariel 10")
        self.canvas.create_image(420, 490, image=self.doprava)
        self.canvas.create_image(50, 490, image=self.dolava)
            #oblecenie
        self.canvas.create_text(50, 550, text="Oblecenie", font="Ariel 10")
        self.canvas.create_image(420, 570, image=self.doprava)
        self.canvas.create_image(50, 570, image=self.dolava)
            #telo
        self.canvas.create_text(50, 590, text="Telo", font="Ariel 10")
        self.canvas.create_image(420, 610, image=self.doprava)
        self.canvas.create_image(50, 610, image=self.dolava)
            #tlacidlo random
        self.canvas.create_rectangle(210, 635, 260, 657, fill="#ff6d7e")
        self.canvas.create_text(235, 646, text="Random", font="Ariel 9")
        #tlacidlo Spat
        self.canvas.create_rectangle(68, 635, 178, 680, fill="#ff6d7e")
        self.canvas.create_text(123, 657, text="Spat", font="Ariel 18")
        #tlacidlo Start
        self.canvas.create_rectangle(292, 635, 402, 680, fill="#ff6d7e")
        self.canvas.create_text(347, 657, text="Start", font="Ariel 18")
        #foto a uvodny text
        self.background = tkinter.PhotoImage(file="obrazky\\uvod-{}.png".format(random.randint(1,5)))
        self.background = self.background.subsample(2,3)
        self.canvas.create_image(875, 155, image=self.background)
        self.canvas.create_text(725, 300, text="Vitajte pri hre Formula Simulator 2018!", font="Ariel 15")
        self.canvas.create_text(875, 435, text=self.spracuj_text("data\\nova_hra_text.txt", 100), font="Ariel 10")


    def ulozene_pozicie(self, text):
        #nastavenie
        self.obrazovka = text
        nova_hra = False
        if(text == "nova_hra_save"):
            nova_hra = True
        self.canvas.delete("all")
        self.canvas.configure(bg="#e2e2e2")
        self.subory = self.nacitaj_ulozene_pozicie()
        #Uvodny text
        self.canvas.create_text(137, 100, text="Vyberte subor:", font="Ariel 18 bold")
        if(nova_hra):
            self.canvas.create_text(155, 140, text="Do ktoreho sa ulozi hra", font="Ariel 15")
        else:
            self.canvas.create_text(155, 140, text="Z ktoreho sa nacita hra", font="Ariel 15")
        
        #ciara
        self.canvas.create_line(470, 35, 470, 685, fill="black")
        #vykreslenie
        for i, subor in enumerate(self.subory):
            meno_suboru, datum, meno_manazera, meno_teamu, prazdny_slot = subor
            if(i == self.subor_cislo):
                self.canvas.create_rectangle(50, 200 + (i * 80), 420, 200 + (i * 80) + 50, fill="white", width=3, outline="red")
            else:
                self.canvas.create_rectangle(50, 200 + (i * 80), 420, 200 + (i * 80) + 50, fill="white")
            self.canvas.create_text(235, 225 + (i * 80), text=meno_suboru, font="Ariel 18")

            if(i == self.subor_cislo):
                #meno
                self.canvas.create_text(800, 225, text="Meno suboru:", font="Ariel 18 bold")
                self.canvas.create_text(1050, 225, text=meno_suboru, font="Ariel 18")
                #datum
                self.canvas.create_text(800, 275, text="Datum:", font="Ariel 18 bold")
                self.canvas.create_text(1050, 275, text=datum, font="Ariel 18")
                #meno_manazera
                self.canvas.create_text(800, 325, text="Meno manazera:", font="Ariel 18 bold")
                self.canvas.create_text(1050, 325, text=meno_manazera, font="Ariel 18")
                #meno_teamu
                self.canvas.create_text(800, 375, text="Meno Teamu:", font="Ariel 18 bold")
                self.canvas.create_text(1050, 375, text=meno_teamu, font="Ariel 18")
                #Je prazdny_slot?
                if(prazdny_slot):
                    self.canvas.create_text(925, 425, text="Prazdny slot!", fill="red", font="Ariel 18 bold")

        #Tlacidlo 'Prepisat' a 'Nacitat'
        if(nova_hra):
            self.canvas.create_rectangle(1000, 635, 1110, 680, fill="#ff6d7e")
            self.canvas.create_text(1055, 657, text="Prepisat", font="Ariel 18")
        else:
            self.canvas.create_rectangle(1000, 635, 1110, 680, fill="#ff6d7e")
            self.canvas.create_text(1055, 657, text="Nacitat", font="Ariel 18")
        #Tlacidlo 'Spat'
        self.canvas.create_rectangle(800, 635, 910, 680, fill="#ff6d7e")
        self.canvas.create_text(855, 657, text="Spat", font="Ariel 18")

    def prepisat(self):
        #nastavenie
        self.obrazovka = "prepisat"
        
        self.canvas.create_rectangle(440, 260, 840, 460, fill="white", width="3")
        if(self.subor_cislo not in range(0,6)):
            self.canvas.create_text(640, 330, text="Nevybral si ziaden subor!", font="Ariel 15 bold")
            #Tlacidlo 'Ok'
            self.canvas.create_rectangle(585, 400, 695, 445, fill="#ff6d7e")
            self.canvas.create_text(640, 422, text="Ok", font="Ariel 18")
        else:
            self.canvas.create_rectangle(440, 260, 840, 460, fill="white", width="3")
            #Povodny nazov
            self.canvas.create_text(540, 310, text="Povodny nazov", font="Ariel 15")
            self.canvas.create_text(740, 310, text=self.subory[self.subor_cislo][0], font="Ariel 15")
            #Entry
            self.canvas.create_text(550, 360, text="Nazov suboru:", font="Ariel 15")
            self.novy_team_info["meno_suboru"] = tkinter.Entry(master=self.canvas, font="Ariel 15")
            self.novy_team_info["meno_suboru"].pack()
            self.novy_team_info["meno_suboru"].place(x=665, y=350, width=150, height=30)
            #Tlacidlo 'Spat'
            self.canvas.create_rectangle(485, 400, 595, 445, fill="#ff6d7e")
            self.canvas.create_text(540, 422, text="Spat", font="Ariel 18")
            #Tlacidlo 'Potvrdit'
            self.canvas.create_rectangle(685, 400, 795, 445, fill="#ff6d7e")
            self.canvas.create_text(740, 422, text="Potvrdit", font="Ariel 18")

    def prepisat_potvrdenie(self):
        dirname = os.path.dirname(__file__)
        filename = os.path.join(dirname, "data/save/")
        stary_subor = filename + self.subory[self.subor_cislo][0] + ".txt"
        novy_subor = filename + self.novy_team_info["meno_suboru"].get() + ".txt"
        os.rename(stary_subor, novy_subor)

        self.subor_cesta = novy_subor
        self.sezona.ulozit(novy_subor)

    def nacitat(self):
        self.obrazovka = "nacitat"
        #
        dirname = os.path.dirname(__file__)
        filename = os.path.join(dirname, "data/save/")
        #pokial nie je prazdny
        if(not self.subory[self.subor_cislo][4]):
            subor = filename + self.subory[self.subor_cislo][0] + ".txt"
            self.subor_cesta = subor
            self.sezona = Sezona.Sezona(self.canvas).nacitat(subor)
            self.jazdec_1, self.jazdec_2 = self.sezona.hrac_team.jazdci
            if(self.sezona.faza_preteku in range(1,4)):
                self.tlacidlo_pretek = "Trening c.{}".format(self.sezona.faza_preteku)
            if(self.sezona.faza_preteku == 4):
                self.tlacidlo_pretek = "Kvalifikacia"
            self.hra()
        else:
            self.canvas.create_rectangle(440, 260, 840, 460, fill="white", width="3")
            self.canvas.create_text(640, 330, text="Tento save je prazdny. Nemozno nacitat!", font="Ariel 15 bold")
            #Tlacidlo 'Ok'
            self.canvas.create_rectangle(585, 400, 695, 445, fill="#ff6d7e")
            self.canvas.create_text(640, 422, text="Ok", font="Ariel 18")

        #self.canvas.delete("all")
        #for i, team in enumerate(self.sezona.teamy):
            #self.canvas.create_text(250, 50 + i * 30, text=team.meno_teamu)

    def hra(self):
        #nastavenia
        self.obrazovka = "hra"
        self.canvas.delete("all")
        #
        self.sezona.vykresli_sezona_info(950, 15)
        self.sezona.hrac_team.vykresli_info_o_jazdcoch(60, 360)
        self.sezona.vykresli_poradie_jazdcov(840, 360, 10)
        self.sezona.hrac_team.auto.vykresli_auto_info(450, 360)
        #Tlacidlo "Odist"
        self.canvas.create_rectangle(1110, 200, 1220, 245, fill="#ff6d7e")
        self.canvas.create_text(1165, 222, text="Odist", font="Ariel 18")
        #Tlacidlo "Sampionaty"
        self.canvas.create_rectangle(320, 200, 530, 245, fill="#ff6d7e")
        self.canvas.create_text(425, 222, text="Sampionaty", font="Ariel 18")
        #Tlacidlo "Statistiky"
        self.canvas.create_rectangle(320, 145, 530, 190, fill="#ff6d7e")
        self.canvas.create_text(425, 167, text="Statistiky", font="Ariel 18")
        #Tlacidlo "NOVY PRETEK"
        self.canvas.create_rectangle(60, 145, 270, 245, fill="#ff6d7e")
        self.canvas.create_text(165, 195, text=self.tlacidlo_pretek, font="Ariel 18 bold")

    def pretek(self):
        self.trening_tlacidlo = False
        if(self.sezona.faza_preteku == 1):
            self.trening(self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], True)
            self.tlacidlo_pretek = "Trening c.2"
        if(self.sezona.faza_preteku == 2):
            self.trening(self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], True)
            self.tlacidlo_pretek = "Trening c.3"
        if(self.sezona.faza_preteku == 3):
            self.trening(self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], True)
            self.tlacidlo_pretek = "Kvalifikacia"
            #self.faza_preteku = 1
        if(self.sezona.faza_preteku == 4):
            self.kvalifikacia(self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1])
            self.tlacidlo_pretek = "Hlavny pretek"
        if(self.sezona.faza_preteku == 5):
            self.sezona.strategia()
            self.trening(self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], False)
            self.tlacidlo_pretek = "Trening c.1"

    def kvalifikacia(self, kolo, max_kolo):
        #nastavenia
        self.obrazovka = "kvalifikacia"
        self.canvas.delete("all")
        #info
        trat_nazov = self.sezona.trate[self.sezona.podujatie - 1].nazov
        self.canvas.create_text(1050, 20, text="VC " + trat_nazov, font="Ariel 15 bold")
        self.canvas.create_text(1050, 50, text="Kvalifikacia: {}/{}".format(kolo, max_kolo), font="Ariel 15 bold")
        #tabulka casov
        self.sezona.vykresli_poradie_jazdcov_najlepsie_kolo(835, 80)
        #Jazdec 1
        self.jazdec_1.vykresli_info_jazdca(35, 60)
        self.canvas.create_text(140, 220, text="Posledne kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 220, text=self.jazdec_1.cas(self.jazdec_1.posledne_kolo), font="Ariel 15")
        self.canvas.create_text(155, 245, text="Najrychlejsie kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 245, text=self.jazdec_1.cas(self.jazdec_1.najlepsie_kolo), font="Ariel 15")
        #jazdec 2
        self.jazdec_2.vykresli_info_jazdca(25, 420)
        self.canvas.create_text(140, 580, text="Posledne kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 580, text=self.jazdec_2.cas(self.jazdec_2.posledne_kolo), font="Ariel 15")
        self.canvas.create_text(155, 605, text="Najrychlejsie kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 605, text=self.jazdec_2.cas(self.jazdec_2.najlepsie_kolo), font="Ariel 15")

        #---UPDATE
        self.sezona.kvalifikacia(kolo)
        self.sezona.jazda(False, kolo)        
        if(kolo != max_kolo):
            self.sezona.kolo += 1
            self.procesy["kvalifikacia"] = self.canvas.after(1000, self.kvalifikacia, self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1])
        else:
            self.trening_tlacidlo = True
            self.canvas.after_cancel(self.procesy["kvalifikacia"])
            self.sezona.skusenosti_jazdci("kvalifikacia")
            self.sezona.reset_jazdci("faza")
            #vykresli tlacidlo na odchod
            self.canvas.create_rectangle(1110, 668, 1220, 713, fill="#ff6d7e")
            self.canvas.create_text(1165, 690, text="Dalej", font="Ariel 18")

    def trening(self, kolo, max_kolo, trening):
        #PITSTOP
        if(self.pitstop):
            self.canvas.after_cancel(self.procesy["trening"])
            if(self.jazdec_1.pitstop):
                self.pitstop_okno(self.jazdec_1)
            if(self.jazdec_2.pitstop):
                self.pitstop_okno(self.jazdec_2)
            return 
        #nastavenia
        self.obrazovka = "trening"
        self.canvas.delete("all")
        #Info
        trat_nazov = self.sezona.trate[self.sezona.podujatie - 1].nazov
        self.canvas.create_text(1050, 20, text="VC " + trat_nazov, font="Ariel 15 bold")
        if(trening):
            self.canvas.create_text(1050, 50, text="Trening: {}/{}".format(kolo, max_kolo), font="Ariel 15 bold")
        else:
            self.canvas.create_text(1050, 50, text="Pretek: {}/{}".format(kolo, max_kolo), font="Ariel 15 bold")
        #tabulka casov
        if(trening):
            self.sezona.vykresli_poradie_jazdcov_najlepsie_kolo(835, 80)
        else:
            self.sezona.vykresli_poradie_jazdcov_najlepsi_cas(835, 80)
        ####jazdec 1
        self.jazdec_1.vykresli_info_jazdca(35, 60)
        self.jazdec_1.auto.vykresli_auto_info_pretek(465, 60)
        self.canvas.create_text(140, 220, text="Posledne kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 220, text=self.jazdec_1.cas(self.jazdec_1.posledne_kolo), font="Ariel 15")
        self.canvas.create_text(155, 245, text="Najrychlejsie kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 245, text=self.jazdec_1.cas(self.jazdec_1.najlepsie_kolo), font="Ariel 15")
        #Pritlak jazdec 1
        try:
            self.info_jazdec_1["pritlak"].vykresli()
        except:
            self.info_jazdec_1["pritlak"] = self.Posuvnik(self.canvas, 60, 280, 690, 99)
            self.info_jazdec_1["pritlak"].vykresli()
        self.canvas.create_text(120, 320, font="Ariel 15",
                                text="Pritlak: {}".format(self.info_jazdec_1["pritlak"].get()))
        #Tlacidlo 'Pitstop jazdec_1'
        self.canvas.create_rectangle(550, 300, 660, 345, fill="#ff6d7e")
        self.canvas.create_text(605, 322, text="Pitstop", font="Ariel 18")
        ####jazdec 2
        self.jazdec_2.vykresli_info_jazdca(25, 420)
        self.jazdec_2.auto.vykresli_auto_info_pretek(465, 420)
        self.canvas.create_text(140, 580, text="Posledne kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 580, text=self.jazdec_2.cas(self.jazdec_2.posledne_kolo), font="Ariel 15")
        self.canvas.create_text(155, 605, text="Najrychlejsie kolo:", font="Ariel 15 bold")
        self.canvas.create_text(300, 605, text=self.jazdec_2.cas(self.jazdec_2.najlepsie_kolo), font="Ariel 15")
        #Pritlak jazdec 2
        try:
            self.info_jazdec_2["pritlak"].vykresli()
        except:
            self.info_jazdec_2["pritlak"] = self.Posuvnik(self.canvas, 60, 640, 690, 99)
            self.info_jazdec_2["pritlak"].vykresli()
        self.canvas.create_text(120, 700, font="Ariel 15",
                                text="Pritlak: {}".format(self.info_jazdec_2["pritlak"].get()))
        #Tlacidlo 'Pitstop jazdec_2'
        self.canvas.create_rectangle(550, 660, 660, 705, fill="#ff6d7e")
        self.canvas.create_text(605, 682, text="Pitstop", font="Ariel 18")
        #
        self.canvas.create_line(30, 360, 640, 360, width=2)


        #---UPDATE
        self.sezona.jazda(not trening, self.sezona.kolo)        
        if(kolo != max_kolo):
            self.sezona.kolo += 1
            self.procesy["trening"] = self.canvas.after(750, self.trening, self.sezona.kolo, self.sezona.max_kolo[self.sezona.faza_preteku - 1], trening)
        else:
            self.trening_tlacidlo = True
            self.canvas.after_cancel(self.procesy["trening"])
            self.sezona.skusenosti_jazdci("trening")
            if(trening):
                self.sezona.reset_jazdci("faza")
            else:
                self.sezona.reset_jazdci("preteky")
            #vykresli tlacidlo na odchod
            self.canvas.create_rectangle(1110, 668, 1220, 713, fill="#ff6d7e")
            self.canvas.create_text(1165, 690, text="Dalej", font="Ariel 18")

    def pitstop_okno(self, jazdec):
        self.info_pitstop["jazdec"] = jazdec
        self.info_pitstop["obrazok-S"] = tkinter.PhotoImage(file="obrazky\\pneumatika\\pneumatika-S.png")
        self.info_pitstop["obrazok-M"] = tkinter.PhotoImage(file="obrazky\\pneumatika\\pneumatika-M.png")
        self.info_pitstop["obrazok-H"] = tkinter.PhotoImage(file="obrazky\\pneumatika\\pneumatika-H.png")
        #nastavenia
        self.obrazovka = "pitstop"
        self.canvas.delete("all")
        #Vykresli
        jazdec.vykresli_info_jazdca(450,60)
        jazdec.auto.vykresli_auto_info_pretek(480, 220)
        #Posuvnik na palivo
        try:
            self.canvas.create_text(640, 390, text="Kolko litrov chces dotankovat? {:2}/{}".format(self.info_pitstop["palivo"].get() - 1, int(100-jazdec.auto.palivo)),font="Ariel 15 bold")
        except:
            self.canvas.create_text(640, 390, text="Kolko litrov chces dotankovat? {:0}/{}".format(0, int(100-jazdec.auto.palivo)), font="Ariel 15 bold")
            self.info_pitstop["palivo"] = self.Posuvnik(self.canvas, 450, 420, 380, int(100-jazdec.auto.palivo))
        self.info_pitstop["palivo"].vykresli()
        #obrazky
        self.canvas.create_image(510, 600, image=self.info_pitstop["obrazok-S"])
        self.canvas.create_image(640, 600, image=self.info_pitstop["obrazok-M"])
        self.canvas.create_image(770, 600, image=self.info_pitstop["obrazok-H"])
        try:
            x = 460 + self.info_pitstop["pneumatiky"] * 130
            self.canvas.create_rectangle(x, 550, x + 100, 650, outline="red", width=2)
        except:
            pass
        #Tlacidlo 'Pitstop'
        self.canvas.create_rectangle(1110, 668, 1220, 713, fill="#ff6d7e")
        self.canvas.create_text(1165, 690, text="Pitstop", font="Ariel 18")
        
        
    def TEST(self):
        self.obrazovka = "test"
        self.canvas.delete("all")
        #
        self.sezona.TEST_vykresli_jazdci()
        self.sezona.jazda()

    def nacitaj_ulozene_pozicie(self):
        subory = []
        dirname = os.path.dirname(__file__)
        filename = os.path.join(dirname, "data/save")
        for file in os.listdir(filename):
            if file.endswith(".txt"):
                meno_suboru = file[:-4]
                fullname = os.path.join(filename, file)
                time = os.path.getmtime(fullname)
                datum = datetime.fromtimestamp(int(time)).strftime('%d.%m.%Y %H:%M:%S')
                text_subor = open(fullname, "r")
                for riadok in text_subor:
                    kluc, hodnota = riadok.strip().split("=")
                    if(kluc == "zakladne_info"):
                        meno_manazera, meno_teamu = hodnota.split(";")
                        subory += [[meno_suboru, datum, meno_manazera, meno_teamu]]
                    if(kluc == "prazdny_slot"):
                        if(hodnota == "True"):
                            subory[-1].append(True)
                        else:
                            subory[-1].append(False)
                        break
                text_subor.close()
        return subory                     
        
    def start_novej_hry(self):
        meno_teamu = self.novy_team_info["meno_teamu"].get()
        
        meno_manazera = self.novy_team_info["meno_manazera"].get()
        self.novy_team_info["manazer"].meno = meno_manazera
        manazer = self.novy_team_info["manazer"]
        
        peniaze = 100000000 // self.novy_team_info["posuvnik_obtiaznost"].get()
        dlzka_sezony = 15 + self.novy_team_info["posuvnik_sezona"].get()

        team = Team.Team(self.canvas, meno_teamu, manazer, peniaze)
        sezona = Sezona.Sezona(self.canvas, hrac_team=team, dlzka=dlzka_sezony, nova_sezona=True, obtiaznost=self.novy_team_info["posuvnik_obtiaznost"].get())

        #priradenie sezony
        self.sezona = sezona
        self.jazdec_1, self.jazdec_2 = self.sezona.hrac_team.jazdci
        self.ulozene_pozicie("nova_hra_save")

    def sampionaty(self):
        #nastavenie
        self.obrazovka = "sampionaty"
        self.canvas.delete("all")
        #nadpis
        self.canvas.create_text(640, 50, font="Ariel 20 bold", text="Poradie sampionatov")
        self.canvas.create_text(640, 80, font="Ariel 15", text="Pocet VC: {}/{}".format(self.sezona.podujatie,
                                                                                         self.sezona.dlzka))
        #vykresli sampionaty
        self.sezona.vykresli_poradie_jazdcov(130, 130, 20)
        self.sezona.vykresli_poradie_tymov(770, 130, 10)
        #Tlacidlo 'Odist'
        self.canvas.create_rectangle(1110, 668, 1220, 713, fill="#ff6d7e")
        self.canvas.create_text(1165, 690, text="Odist", font="Ariel 18")

    def statistiky(self):
        #Nastavenia
        self.obrazovka = "statistiky"
        self.canvas.delete("all")
        #Info
        self.canvas.create_text(640, 50, font="Ariel 20 bold", text="Statistiky")

        jazdci = self.sezona.jazdci
        jazdci.sort(key=lambda x: x.body, reverse=True)
        dielik = int(900 / self.sezona.dlzka)
        
        #Vykresli
        for i, jazdec in enumerate(jazdci):
            farba = "#e2e2e2"
            predchadzajuce = (200, 114 + i*28)
            self.canvas.create_rectangle(60, 100 + i*28, 200, 128 + i*28, fill=farba)
            self.canvas.create_text(130, 114 + i*28, font="Ariel 12 bold", text=jazdec.meno)
            for m, miesto in enumerate(jazdec.umiestnenia):
                if(miesto == 1):
                    farba = "#edcc4e"
                elif(miesto == 2):
                    farba = "#e2dece"
                elif(miesto == 3):
                    farba = "#cd7f32"
                else:
                    farba = "white"
                self.canvas.create_rectangle(230 + m*dielik, 100 + i*28, 250 + m*dielik, 128 + i*28, fill=farba)
                self.canvas.create_text(240 + m*dielik, 114 + i*28, font="Ariel 12 bold", text=str(miesto), fill="black")
                nove = (230 + m*dielik, 114 + i*28)
                farba = "black"
                self.canvas.create_line(predchadzajuce, nove, fill=farba, width=2)
                predchadzajuce = (250 + m*dielik, 114 + i*28)
        #Tlacidlo 'Odist'
        self.canvas.create_rectangle(1110, 668, 1220, 713, fill="#ff6d7e")
        self.canvas.create_text(1165, 690, text="Odist", font="Ariel 18")       

    def nabinduj(self):
        self.canvas.bind_all("<Button-1>", self.klik)
        self.canvas.bind("<B1-Motion>", self.tahanie)
        
    def tahanie(self, event):
        if(self.obrazovka == "nova hra"):
            if(event.x in self.novy_team_info["posuvnik_obtiaznost"].range_x() and event.y in self.novy_team_info["posuvnik_obtiaznost"].range_y()):
                self.novy_team_info["posuvnik_obtiaznost"].nastav(event.x)
            if(event.x in self.novy_team_info["posuvnik_sezona"].range_x() and event.y in self.novy_team_info["posuvnik_sezona"].range_y()):
                self.novy_team_info["posuvnik_sezona"].nastav(event.x)
                
        if(self.obrazovka == "trening"):
            if(event.x in self.info_jazdec_1["pritlak"].range_x() and event.y in self.info_jazdec_1["pritlak"].range_y()):
                self.info_jazdec_1["pritlak"].nastav(event.x)
                self.jazdec_1.auto.pritlak = self.info_jazdec_1["pritlak"].get()
            if(event.x in self.info_jazdec_2["pritlak"].range_x() and event.y in self.info_jazdec_2["pritlak"].range_y()):
                self.info_jazdec_2["pritlak"].nastav(event.x)
                self.jazdec_2.auto.pritlak = self.info_jazdec_2["pritlak"].get()

        if(self.obrazovka == "pitstop"):
            if(event.x in self.info_pitstop["palivo"].range_x() and event.y in self.info_pitstop["palivo"].range_y()):
                self.info_pitstop["palivo"].nastav(event.x)
                self.pitstop_okno(self.info_pitstop["jazdec"])

hra = Program()
